'''OpenGL extension EXT.texture_env_combine

Overview (from the spec)
	
	    New texture environment function COMBINE_EXT allows programmable
	    texture combiner operations, including:
	
	        REPLACE                 Arg0
	        MODULATE                Arg0 * Arg1
	        ADD                     Arg0 + Arg1
		ADD_SIGNED_EXT          Arg0 + Arg1 - 0.5
	        INTERPOLATE_EXT         Arg0 * (Arg2) + Arg1 * (1-Arg2)
	
	    where Arg0, Arg1 and Arg2 are derived from
	
		PRIMARY_COLOR_EXT       primary color of incoming fragment
	        TEXTURE                 texture color of corresponding texture unit
	        CONSTANT_EXT            texture environment constant color
	        PREVIOUS_EXT            result of previous texture environment; on
					texture unit 0, this maps to PRIMARY_COLOR_EXT
	
	    and Arg2 is restricted to the alpha component of the corresponding source.
	
	    In addition, the result may be scaled by 1.0, 2.0 or 4.0.

The official definition of this extension is available here:
	http://oss.sgi.com/projects/ogl-sample/registry/EXT/texture_env_combine.txt

Automatically generated by the get_gl_extensions script, do not edit!
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions
from OpenGL.GL import glget
import ctypes
GL_COMBINE_EXT = constant.Constant( 'GL_COMBINE_EXT', 0x8570 )
GL_COMBINE_RGB_EXT = constant.Constant( 'GL_COMBINE_RGB_EXT', 0x8571 )
GL_COMBINE_ALPHA_EXT = constant.Constant( 'GL_COMBINE_ALPHA_EXT', 0x8572 )
GL_RGB_SCALE_EXT = constant.Constant( 'GL_RGB_SCALE_EXT', 0x8573 )
GL_ADD_SIGNED_EXT = constant.Constant( 'GL_ADD_SIGNED_EXT', 0x8574 )
GL_INTERPOLATE_EXT = constant.Constant( 'GL_INTERPOLATE_EXT', 0x8575 )
GL_CONSTANT_EXT = constant.Constant( 'GL_CONSTANT_EXT', 0x8576 )
GL_PRIMARY_COLOR_EXT = constant.Constant( 'GL_PRIMARY_COLOR_EXT', 0x8577 )
GL_PREVIOUS_EXT = constant.Constant( 'GL_PREVIOUS_EXT', 0x8578 )
GL_SOURCE0_RGB_EXT = constant.Constant( 'GL_SOURCE0_RGB_EXT', 0x8580 )
GL_SOURCE1_RGB_EXT = constant.Constant( 'GL_SOURCE1_RGB_EXT', 0x8581 )
GL_SOURCE2_RGB_EXT = constant.Constant( 'GL_SOURCE2_RGB_EXT', 0x8582 )
GL_SOURCE0_ALPHA_EXT = constant.Constant( 'GL_SOURCE0_ALPHA_EXT', 0x8588 )
GL_SOURCE1_ALPHA_EXT = constant.Constant( 'GL_SOURCE1_ALPHA_EXT', 0x8589 )
GL_SOURCE2_ALPHA_EXT = constant.Constant( 'GL_SOURCE2_ALPHA_EXT', 0x858A )
GL_OPERAND0_RGB_EXT = constant.Constant( 'GL_OPERAND0_RGB_EXT', 0x8590 )
GL_OPERAND1_RGB_EXT = constant.Constant( 'GL_OPERAND1_RGB_EXT', 0x8591 )
GL_OPERAND2_RGB_EXT = constant.Constant( 'GL_OPERAND2_RGB_EXT', 0x8592 )
GL_OPERAND0_ALPHA_EXT = constant.Constant( 'GL_OPERAND0_ALPHA_EXT', 0x8598 )
GL_OPERAND1_ALPHA_EXT = constant.Constant( 'GL_OPERAND1_ALPHA_EXT', 0x8599 )
GL_OPERAND2_ALPHA_EXT = constant.Constant( 'GL_OPERAND2_ALPHA_EXT', 0x859A )


def glInitTextureEnvCombineEXT():
	'''Return boolean indicating whether this extension is available'''
	return extensions.hasGLExtension( 'GL_EXT_texture_env_combine' )
